##### PREPROCESSING #####
#
# 
import os
import pandas as pd
import shutil
from sklearn.preprocessing import MinMaxScaler


def drop_metadati(paziente):
    # tolgo metadati
    meta_dati = [ col for col in paziente.columns if (('diagnostics_' in col) | ('coordx' in col) | ('coordy' in col))]
    paziente = paziente.drop(columns=meta_dati)
    #
    return paziente


def drop_feature_instabili(paziente):
    #
    # Elimina le feature instabili per tutti i pazienti
    #
    feature_instabili=['original_firstorder_90Percentile',
                       'original_firstorder_Maximum',
                       'original_firstorder_Minimum',
                       'original_firstorder_Range',
                       'original_firstorder_Uniformity',
                       'original_glcm_JointEnergy',
                       'original_glcm_MaximumProbability',
                       'original_glszm_LargeAreaEmphasis',
                       'original_glszm_LargeAreaHighGrayLevelEmphasis',
                       'original_glszm_LargeAreaLowGrayLevelEmphasis',
                       'original_glszm_ZoneVariance',
                       'original_gldm_GrayLevelNonUniformity',
                       'original_glrlm_LongRunEmphasis',
                       'original_glrlm_LongRunHighGrayLevelEmphasis',
                       'original_glrlm_LongRunLowGrayLevelEmphasis',
                       'original_glrlm_RunVariance']
    
    # Rimuove le feature se presenti nel dataset
    paziente = paziente.drop(columns=[col for col in feature_instabili if col in paziente.columns], errors='ignore')
    
    return paziente



def divisione_I_F(path_dataset):

    # il sottoprogramma crea due cartelle in cui verranno divisi i pazienti I e F mentre i 
    # restanti pazienti verranno mantenuti in entrambi i nuovi dataset
    
    output_I= os.path.join(path_dataset, "Dataset I")
    os.makedirs(output_I, exist_ok=True)
    output_F= os.path.join(path_dataset, "Dataset F")
    os.makedirs(output_F, exist_ok=True)
    output_I_singoli= os.path.join(output_I, "Pazienti Singoli")
    os.makedirs(output_I_singoli, exist_ok=True)
    output_F_singoli= os.path.join(output_F, "Pazienti singoli")
    os.makedirs(output_F_singoli, exist_ok=True)
    
    dataset = [os.path.join(path_dataset, _) for _ in os.listdir(path_dataset) if _.endswith('.csv')]
    
    for file_path in dataset:
        #
        nome_paziente =  os.path.basename(file_path).split('_')[0]
        # controllo se il paziente è F
        if nome_paziente.endswith((' F', ' f')):
            
            shutil.move(file_path, os.path.join(output_F_singoli, os.path.basename(file_path)))
             
        elif nome_paziente.endswith((' I', ' i')):
            
            shutil.move(file_path, os.path.join(output_I_singoli, os.path.basename(file_path)))
            
        else:
            # Pazienti da mantenere in entrambi: spostiamo in F e copiamo in I
            shutil.move(file_path, os.path.join(output_F_singoli, os.path.basename(file_path)))
            shutil.copy(os.path.join(output_F_singoli, os.path.basename(file_path)), os.path.join(output_I_singoli, os.path.basename(file_path)))

      
    print('Processo di separazione I e F completato!')
    return output_F_singoli, output_I_singoli

    

def preprocessing(path_dataset, path_output):
    
    dataset = [os.path.join(path_dataset, _) for _ in os.listdir(path_dataset) if _.endswith('.csv')]
    
    for file_path in dataset:
        
        #ricavo nome paziente
        nome_paziente = os.path.basename(file_path).split('_')[0]
        # leggo il paziente 
        paziente= pd.read_csv(file_path, index_col=0)
        # tolgo metadati al paziente 
        paziente = drop_metadati(paziente)
        # tolgo feature incompatibili tra F e I
        paziente = drop_feature_instabili(paziente)
        # normalizzo il paziente con MinMaxScaler
        scaler = MinMaxScaler(feature_range=(0,1))
        paziente_normalizzato = pd.DataFrame(scaler.fit_transform(paziente), columns = paziente.columns)
        # Salvo il paziente pre-processato e normalizzato
        output_file = os.path.join(path_output, f"{nome_paziente}_preprocessed.csv")
        print(f"Sto salvando il file: {output_file}")
        paziente_normalizzato.to_csv(output_file, index=False)  

    
    # divido i dataset
    path_dataset_F, path_dataset_I = divisione_I_F(path_output)
    
    # controllo se alcuni file non corrispondevano alle carateristiche e sono stati eliminati forzatamente
    count=0
    rimossi = []
    for file in os.listdir(path_output):
        if file.endswith('.csv'):
            os.remove(os.path.join(path_output, file))
            nome_file =  os.path.basename(file_path).split('_')[0]
            rimossi.append(nome_file)
            count+=1
    if count > 0:
        print(f"File rimossi forzatamete: {count}. Richiesta verifica! \n")
        print(rimossi)
    elif count==0:
        print("Tutti i file sono stati divisi correttamente!")
    
    return path_dataset_F, path_dataset_I